// firstLastList.java
// demonstruje dziaanie listy dwustronnej
// uruchomienie programu: C>java FirstLastApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;                 // dane
   public Link next;                  // nastpny element listy
// -------------------------------------------------------------
   public Link(long d)                // konstruktor
      { dData = d; }
// -------------------------------------------------------------
   public void displayLink()          // wypisanie danych
      { System.out.print(dData + " "); }
// -------------------------------------------------------------
   }  // end class Link
////////////////////////////////////////////////////////////////
class FirstLastList
   {
   private Link first;               // referencja do pierwszego elementu
   private Link last;                // referencja do ostatniego elementu
// -------------------------------------------------------------
   public FirstLastList()            // konstruktor
      {
      first = null;                  // lista nie zawiera jeszcze elementw
      last = null;
      }
// -------------------------------------------------------------
   public boolean isEmpty()          // zwraca true, jeeli lista jest pusta
      { return first==null; }
// -------------------------------------------------------------
   public void insertFirst(long dd)  // wstawienie na pocztek listy
      {
      Link newLink = new Link(dd);   // tworzymy nowy element

      if( isEmpty() )                // jeeli lista jest pusta...
         last = newLink;             // ...last --> newLink
      newLink.next = first;          // newLink --> poprzedni pierwszy
      first = newLink;               // first --> newLink
      }
// -------------------------------------------------------------
   public void insertLast(long dd)   // wstawienie na koniec listy
      {
      Link newLink = new Link(dd);   // tworzymy nowy element
      if( isEmpty() )                // jeeli lista jest pusta...
         first = newLink;            // ...first --> newLink
      else
         last.next = newLink;        // poprzedni ostatni --> newLink
      last = newLink;                // last --> newLink
      }
// -------------------------------------------------------------
   public long deleteFirst()         // usunicie pierwszego elementu
      {                              // (zakadamy, e lista nie jest pusta)
      long temp = first.dData;
      if(first.next == null)         // jeeli tylko jeden element...
         last = null;                // ...last --> null
      first = first.next;            // first --> poprzedni drugi
      return temp;
      }
// -------------------------------------------------------------
   public void displayList()
      {
      System.out.print("Lista (pocztek-->koniec): ");
      Link current = first;          // zaczynamy od pocztku
      while(current != null)         // dopki nie koniec listy...
         {
         current.displayLink();      // ...wypisujemy zawarto elementu...
         current = current.next;     // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy FirstLastList
////////////////////////////////////////////////////////////////
class FirstLastApp
   {
   public static void main(String[] args)
      {                              // tworzymy now list
      FirstLastList theList = new FirstLastList();

      theList.insertFirst(22);       // wstawiamy na pocztek
      theList.insertFirst(44);
      theList.insertFirst(66);

      theList.insertLast(11);        // wstawiamy na koniec
      theList.insertLast(33);
      theList.insertLast(55);

      theList.displayList();         // wypisujemy zawarto listy

      theList.deleteFirst();         // usuwamy pierwsze dwa elementy
      theList.deleteFirst();

      theList.displayList();         // wypisujemy ponownie
      }  // koniec main()
   }  // koniec klasy FirstLastApp
////////////////////////////////////////////////////////////////
